unit Surface;
{Demonstrates some 3-D-features of MathImage.
 The routines marked by *********** use
 MathImage methods.}

interface

uses
  SysUtils,
  {$IFDEF WINDOWS}
  WinTypes, WinProcs,
  {$ENDIF}
  {$IFDEF WIN32}
  Windows,
  {$ENDIF}
  Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, ExtCtrls, Mathimge;

const tmin=-Pi; tmax=Pi; smin=0; smax=2*Pi;
      tmesh=160; smesh=21; {knot parameter mesh}
      r=1; {radius of knot tube}
      kxmin=-6; kxmax=6; kymin=-6; kymax=6;
      kzmin=-3; kzmax=3; {knot world box}
      gxmin=-Pi; gxmax=Pi; gymin=-Pi; gymax=Pi; {graph domain}
      xmesh=55; ymesh=55; {graph mesh}
      gzmin=-3; gzmax=3; {graph range}

type
  TSurfaceForm = class(TForm)
    Panel1: TPanel;
    KnotButton: TButton;
    FillCheck: TCheckBox;
    WireButton: TButton;
    FillButton: TButton;
    UpButton: TButton;
    LeftButton: TButton;
    RightButton: TButton;
    DownButton: TButton;
    ColorDialog1: TColorDialog;
    InButton: TButton;
    OutButton: TButton;
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    MoveInButton: TButton;
    MoveOutButton: TButton;
    Panel2: TPanel;
    Label4: TLabel;
    Label5: TLabel;
    Label6: TLabel;
    Label7: TLabel;
    vdshow: TLabel;
    vashow: TLabel;
    zrshow: TLabel;
    yrshow: TLabel;
    RadioButton1: TRadioButton;
    RadioButton2: TRadioButton;
    GraphButton: TButton;
    GraphImage: TMathImage;
    procedure WireButtonClick(Sender: TObject);
    procedure FillButtonClick(Sender: TObject);
    procedure KnotButtonClick(Sender: TObject);
    procedure InButtonMouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure InButtonMouseUp(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure OutButtonMouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure OutButtonMouseUp(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure UpButtonMouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure UpButtonMouseUp(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure LeftButtonMouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure RightButtonMouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure DownButtonMouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure FormResize(Sender: TObject);
    procedure MoveOutButtonMouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure MoveOutButtonMouseUp(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure MoveInButtonMouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure MoveInButtonMouseUp(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure GraphButtonClick(Sender: TObject);
  private
  wirecolor,fillcolor:longint;
  zooming,rotating:boolean;
  knotsurface,graphsurface:Tsurface;
  currenttype:integer;
  procedure CreateParams(var Params: TCreateParams); override;
  function x0(t:extended):extended;
  function y0(t:extended):extended;
  function z0(t:extended):extended;
  function x1(t:extended):extended;
  function y1(t:extended):extended;
  function z1(t:extended):extended;
  function x2(t:extended):extended;
  function y2(t:extended):extended;
  function z2(t:extended):extended;
  procedure knot(t,s:extended; var x,y,z:extended);
  procedure graph(x,y:extended; var z:extended);
  procedure makeknotsurface;
  procedure makegraphsurface;
  procedure upd;
    { Private declarations }
  public
    { Public declarations }
  end;

var
  SurfaceForm: TSurfaceForm;

implementation

uses MDemo1;

{$R *.DFM}

procedure TSurfaceForm.CreateParams(var Params: TCreateParams);
begin
  inherited  CreateParams(Params);
  with Params do
  begin
    WndParent := Demoform.Handle;
    Parent := Demoform;
    Style := WS_CHILD OR WS_CLIPSIBLINGS OR WS_CLIPCHILDREN;
    Align := alClient;
  end;
end;


{*************************************}
procedure TSurfaceForm.FormCreate(Sender: TObject);
var i,j:integer; t,s,x,y,z:extended;
    created:boolean;
begin
  with graphimage do
  begin
    d3zrotation:=45; d3yrotation:=35;
    d3viewdist:=5.7; d3viewangle:=6.4;
    wirecolor:=clnavy;
    fillcolor:=claqua;
    controlstyle:=controlstyle+[csOpaque];
  end;
  makeknotsurface;
  makegraphsurface;
  upd;
  currenttype:=1;
end;

procedure TSurfaceForm.WireButtonClick(Sender: TObject);
begin
  with colordialog1 do
  if execute then
  wirecolor:=color;
end;

procedure TSurfaceForm.FillButtonClick(Sender: TObject);
begin
  with colordialog1 do
  if execute then fillcolor:=color;
end;

function TSurfaceForm.x0; {Knot Core Curve}
begin
  result:=2*cos(2*t)+cos(t);
end;

function TSurfaceForm.x1; {1st Derivative}
begin
  result:=-4*sin(2*t)-sin(t);
end;

function TSurfaceForm.x2;  {2nd Derivative}
begin
  result:=-8*cos(2*t)-cos(t);
end;

function TSurfaceForm.y0;  {Knot Core Curve}
begin
  result:=2*sin(2*t)-sin(t);
end;

function TSurfaceForm.y1;
begin
  result:=4*cos(2*t)-cos(t);
end;

function TSurfaceForm.y2;
begin
  result:=-8*sin(2*t)+sin(t);
end;

function TSurfaceForm.z0;  {Knot Core Curve}
begin
  result:=sin(3*t);
end;

function TSurfaceForm.z1;
begin
  result:=3*cos(3*t);
end;

function TSurfaceForm.z2;
begin
  result:=-9*sin(3*t);
end;

procedure TSurfaceForm.knot; {Tube surface about core curve}
var u,v,x3,y3,z3,x4,y4,z4,x5,y5,z5,x6,y6,z6:extended;
begin
  u:=sqr(x1(t))+sqr(y1(t))+sqr(z1(t));
  v:=x1(t)*x2(t)+y1(t)*y2(t)+z1(t)*z2(t);
  x3:=x2(t)*u-x1(t)*v; {1st perp vector}
  y3:=y2(t)*u-y1(t)*v;
  z3:=z2(t)*u-z1(t)*v;
  x4:=y1(t)*z3-z1(t)*y3; {2nd perp vector}
  y4:=z1(t)*x3-x1(t)*z3;
  z4:=x1(t)*y3-y1(t)*x3;
  u:=sqrt(sqr(x3)+sqr(y3)+sqr(z3));
  v:=sqrt(sqr(x4)+sqr(y4)+sqr(z4));
  x5:=x3/u; y5:=y3/u; z5:=z3/u;  {1st normal}
  x6:=x4/v; y6:=y4/v; z6:=z4/v;   {2nd normal}
  x:=2*x0(t)+r*cos(s)*x5+r*sin(s)*x6; {Core curve + circle in normal plane}
  y:=2*y0(t)+r*cos(s)*y5+r*sin(s)*y6;
  z:=2*z0(t)+r*cos(s)*z5+r*sin(s)*z6;
end;

procedure TSurfaceForm.Graph(x,y:extended; var z:extended);
{graph formula}
begin
  z:=3*sin(sqrt(sqr(x)+sqr(y)))*cos(x+y)*sin(2*(x-y));
end;

{**************************}
procedure TSurfaceForm.KnotButtonClick(Sender: TObject);
begin
  screen.cursor:=crhourglass;
  currenttype:=1;
  with graphimage do
  begin
    d3worldx1:=kxmin; d3worldy1:=kymin;
    d3worldx2:=kxmax; d3worldy2:=kymax;
    d3worldz1:=kzmin; d3worldz2:=kzmax;
    clear;
    d3drawworldbox;
    d3drawaxes('x','y','z');
    setcolor(wirecolor);
    canvas.brush.color:=fillcolor;
    d3drawsurface(knotsurface,fillcheck.checked,Radiobutton1.checked);
    canvas.brush.color:=clwhite;
    setcolor(clblack);
  end;
  screen.cursor:=crdefault;
end;

procedure TSurfaceForm.GraphButtonClick(Sender:TObject);
begin
  screen.cursor:=crhourglass;
  currenttype:=2;
  with graphimage do
  begin
    d3worldx1:=gxmin; d3worldy1:=gymin;
    d3worldx2:=gxmax; d3worldy2:=gymax;
    d3worldz1:=gzmin; d3worldz2:=gzmax;
    clear;
    d3drawworldbox;
    d3drawaxes('x','y','z');
    setcolor(wirecolor);
    canvas.brush.color:=fillcolor;
    d3drawsurface(graphsurface,fillcheck.checked,Radiobutton1.checked);
    canvas.brush.color:=clwhite;
    setcolor(clblack);
  end;
  screen.cursor:=crdefault;
end;


{************************************}
procedure TSurfaceForm.makeKnotSurface;
var i,j:integer; t,s,x,y,z:extended;
begin
  KnotSurface:=Tsurface.create(tmesh,smesh);
  for i:=0 to tmesh do
  begin
    t:=tmin+i*(tmax-tmin)/tmesh;
    for j:=0 to smesh do
    with KnotSurface do
    begin
      s:=smin+j*(smax-smin)/smesh;
      knot(t,s,x,y,z);
      make(i,j,x,y,z);
    end;
  end;
end;

{*****************************************}
procedure TSurfaceForm.MakeGraphSurface;
var i,j:integer; x,y,z:extended;
begin
  GraphSurface:=Tsurface.create(xmesh,ymesh);
  for i:=0 to xmesh do
  begin
    x:=gxmin+i*(gxmax-gxmin)/xmesh;
    for j:=0 to ymesh do
    with GraphSurface do
    begin
      y:=gymin+j*(gymax-gymin)/ymesh;
      graph(x,y,z);
      make(i,j,x,y,z);
    end;
  end;
end;


procedure TSurfaceForm.InButtonMouseDown(Sender: TObject;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
  zooming:=true;
  while zooming do
  with graphimage do
  begin
    canvas.pen.mode:=pmNotXor;
    d3drawaxes('x','y','z');
    d3viewangle:=d3viewangle-0.1;
    canvas.pen.mode:=pmCopy;
    d3drawaxes('x','y','z');
    application.processmessages;
    upd;
  end;
end;

{**********************************************}
procedure TSurfaceForm.InButtonMouseUp(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
begin
  zooming:=false;
end;

{etc, etc.................. much redundant code
using copy paste instead of brain}
procedure TSurfaceForm.OutButtonMouseDown(Sender: TObject;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
  zooming:=true;
  while zooming do
  with graphimage do
  begin
    canvas.pen.mode:=pmNotXor;
    d3drawaxes('x','y','z');
    d3viewangle:=d3viewangle+0.1;
    canvas.pen.mode:=pmCopy;
    d3drawaxes('x','y','z');
    application.processmessages;
    upd;
  end;
end;

procedure TSurfaceForm.OutButtonMouseUp(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
begin
  zooming:=false;
end;



procedure TSurfaceForm.UpButtonMouseDown(Sender: TObject;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
  rotating:=true;
  while rotating do
  with graphimage do
  begin
    canvas.pen.mode:=pmNotXor;
    d3drawaxes('x','y','z');
    d3yrotation:=d3yrotation-0.5;
    canvas.pen.mode:=pmCopy;
    d3drawaxes('x','y','z');
    application.processmessages;
    upd;
  end;
end;

procedure TSurfaceForm.UpButtonMouseUp(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
begin
  rotating:=false;
end;

procedure TSurfaceForm.LeftButtonMouseDown(Sender: TObject;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
  rotating:=true;
  while rotating do
  with graphimage do
  begin
    canvas.pen.mode:=pmNotXor;
    d3drawaxes('x','y','z');
    d3zrotation:=d3zrotation-0.5;
    canvas.pen.mode:=pmCopy;
    d3drawaxes('x','y','z');
    application.processmessages;
    upd;
  end;
end;

procedure TSurfaceForm.RightButtonMouseDown(Sender: TObject;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
  rotating:=true;
  while rotating do
  with graphimage do
  begin
    canvas.pen.mode:=pmNotXor;
    d3drawaxes('x','y','z');
    d3zrotation:=d3zrotation+0.5;
    canvas.pen.mode:=pmCopy;
    d3drawaxes('x','y','z');
    application.processmessages;
    upd;
  end;
end;


procedure TSurfaceForm.DownButtonMouseDown(Sender: TObject;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
  rotating:=true;
  while rotating do
  with graphimage do
  begin
    canvas.pen.mode:=pmNotXor;
    d3drawaxes('x','y','z');
    d3yrotation:=d3yrotation+0.5;
    canvas.pen.mode:=pmCopy;
    d3drawaxes('x','y','z');
    application.processmessages;
    upd;
  end;
end;

{****************************}
procedure TSurfaceForm.FormResize(Sender: TObject);
begin
  graphimage.reset;
  application.processmessages;
  if currenttype=1 then
  knotbuttonclick(self)
  else graphbuttonclick(self);
end;

procedure TSurfaceForm.MoveOutButtonMouseDown(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
begin
  zooming:=true;
  while zooming do
  with graphimage do
  begin
    canvas.pen.mode:=pmNotXor;
    d3drawaxes('x','y','z');
    d3viewdist:=d3viewdist+0.02;
    canvas.pen.mode:=pmCopy;
    d3drawaxes('x','y','z');
    application.processmessages;
    upd;
  end;
end;

procedure TSurfaceForm.MoveOutButtonMouseUp(Sender: TObject;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
  zooming:=false;
end;

procedure TSurfaceForm.MoveInButtonMouseDown(Sender: TObject;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
  zooming:=true;
  while zooming do
  with graphimage do
  begin
    canvas.pen.mode:=pmNotXor;
    d3drawaxes('x','y','z');
    d3viewdist:=d3viewdist-0.02;
    canvas.pen.mode:=pmCopy;
    d3drawaxes('x','y','z');
    application.processmessages;
    upd;
  end;
end;

procedure TSurfaceForm.MoveInButtonMouseUp(Sender: TObject;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
  zooming:=false;
end;


procedure tsurfaceform.upd;
begin
  with graphImage do
  begin
    vdshow.caption:=floattostrf(d3viewdist,ffgeneral,4,4);
    vashow.caption:=FloattoStrF(d3viewangle,ffgeneral,4,4);
    zrshow.caption:=FloattoStrF(d3zrotation,ffgeneral,4,4);
    yrshow.caption:=FloattoStrF(d3yrotation,ffgeneral,4,4);
  end;
end;

procedure TSurfaceForm.FormDestroy(Sender: TObject);
begin
  knotsurface.free;
  graphsurface.free;
end;



end.
